import React, {useCallback} from 'react';

import {EAppActions} from 'constants/platforms/TPlatforms';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18n from 'i18n/avia-AviaBooking-TariffsField';

import Link from 'components/Link/Link';

import {useCoordinator, usePlatform} from 'contexts/PlatformContext';

interface IFullFareRulesLinkProps extends IWithClassName, IWithQaAttributes {}

const FullFareRulesLink: React.FC<IFullFareRulesLinkProps> = props => {
    const {className} = props;
    const fullFareRulesLink = i18n.fullDashFareDashRulesDashUrl();

    const {isTravelApp} = usePlatform();
    const coordinator = useCoordinator();

    const handleFullFareRulesLink: React.MouseEventHandler = useCallback(
        e => {
            if (isTravelApp) {
                coordinator.doAction(
                    EAppActions.NAVIGATE_TO_EXTERNAL_URL,
                    fullFareRulesLink,
                );

                e.preventDefault();
            }
        },
        [coordinator, fullFareRulesLink, isTravelApp],
    );

    return (
        <Link
            className={className}
            url={fullFareRulesLink}
            theme="normal"
            target="_blank"
            rel="noopener noreferrer"
            onClick={handleFullFareRulesLink}
            {...prepareQaAttributes(props)}
        >
            {i18n.fullDashFareDashRulesDashLabel()}
        </Link>
    );
};

export default FullFareRulesLink;
