import {ITariffInfo} from 'projects/avia/pages/AviaBooking/types/ITariffInfo';

/**
 * При отсутствии выбранного тарифа показываем два первых тарифа
 * После выбора цены из модалки с тарифами, нужно в боковом меню отобразить выбранный и предыдущий тариф
 *
 * @param tokenFromModal - последний выбранный тариф из модалки с тарифами
 * @param tariffs - список всех тарифов
 */
export default function getTariffsSlice(
    tokenFromModal: string | null,
    tariffs: ITariffInfo[],
): ITariffInfo[] {
    const selectedTariffIndex = tariffs.findIndex(
        tariff => tariff.id === tokenFromModal,
    );

    if (selectedTariffIndex < 1) {
        return tariffs.slice(0, 2);
    }

    return tariffs.slice(selectedTariffIndex - 1, selectedTariffIndex + 1);
}
