import get from 'lodash/get';

import {IBookingVariantModel} from 'server/services/AviaBookingService/variants/types';
import {ISegmentFare} from 'server/api/AviaBookingApi/types/ISegmentFare';
import {ITariffInfo} from 'projects/avia/pages/AviaBooking/types/ITariffInfo';

export const variantModelToTariffInfoList = (
    variants: IBookingVariantModel[],
): ITariffInfo[] =>
    variants.map(variant => ({
        id: variant.id,
        priceInfo: variant.priceInfo,
        promoCampaigns: variant.promoCampaigns,
        fareTerms: get(
            variant,
            'segments[0].flights[0].fareTerms',
        ) as ISegmentFare,
    }));
