import React, {ChangeEvent} from 'react';

import {ITariffInfo} from 'projects/avia/pages/AviaBooking/types/ITariffInfo';

import IPrice from 'utilities/currency/PriceInterface';

import Radiobox from 'components/Radiobox/Radiobox';

import BookingTariffInfo from '../BookingTariffInfo/BookingTariffInfo';

import cx from './TariffsRadioGroup.scss';

interface TariffsRadioGroupProps {
    tariffs: ITariffInfo[];
    value: string;
    onChange: (token: string) => any;
    disabled?: boolean;
    oldPrices: Record<string, IPrice | undefined>;
}

export const TariffsRadioGroup: React.FC<TariffsRadioGroupProps> = props => {
    const options = props.tariffs.map(
        ({fareTerms, priceInfo, id, promoCampaigns}) => ({
            value: id,
            className: cx('radio'),
            label: (
                <BookingTariffInfo
                    fareTerms={fareTerms}
                    price={priceInfo.total}
                    oldPrice={props.oldPrices[id]}
                    plusPromo={promoCampaigns?.plusPromo2021}
                    isInRadio
                />
            ),
        }),
    );

    return (
        <Radiobox
            value={props.value}
            onChange={(event: ChangeEvent<HTMLInputElement>) =>
                props.onChange(event.target.value)
            }
            disabled={props.disabled}
            className={cx('radiogroup')}
            // @ts-ignore
            // спросил в Lego, сказали что можно в label вместо строки передавать ноду,
            // и у них в есть в планах разрешить передавать в label любой  ReactNode тип https://st.yandex-team.ru/ISL-7601
            options={options}
        />
    );
};
