import {EFormKey} from 'constants/form/EFormKey';

import {IFormValidationInfo} from 'types/common/validation/form';
import {EFormGroup} from '../../types/IBookingFormData';

import {lastNameValidation} from './validationRules/lastName';
import {firstNameValidation} from './validationRules/firstName';
import {patronymicValidation} from './validationRules/patronymic';
import {sexValidation} from './validationRules/sex';
import {birthdateValidation} from './validationRules/birthdate';
import {documentNumberValidation} from './validationRules/documentNumber';
import {citizenshipValidation} from './validationRules/citizenship';
import {documentDateValidation} from './validationRules/documentDate';
import {emailValidation} from './validationRules/email';
import {phoneValidation} from './validationRules/phone';
import {loyaltyCardNumberValidation} from './validationRules/loyaltyCard';

export const validationInfo: IFormValidationInfo = {
    id: EFormKey.AVIA_BOOK,
    fieldGroups: [
        {
            id: EFormGroup.passengers,
            fields: [
                lastNameValidation,
                firstNameValidation,
                patronymicValidation,
                sexValidation,
                birthdateValidation,
                documentNumberValidation,
                citizenshipValidation,
                documentDateValidation,
                loyaltyCardNumberValidation,
            ],
        },
        {
            id: EFormGroup.contacts,
            fields: [emailValidation, phoneValidation],
        },
    ],
};
