import {EFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {TField} from 'types/common/validation/form';
import {EValidationType} from 'types/common/validation/validation';
import {EAgeCategory} from 'projects/avia/pages/AviaBooking/types/AgeCategoryType';
import {EAviaPassengerFieldName} from 'projects/avia/pages/AviaBooking/types/IBookingFormPassengersData';
import {EFlightInfoFieldName} from 'projects/avia/pages/AviaBooking/types/IBookingFlightInfo';
import {EFormGroup} from 'projects/avia/pages/AviaBooking/types/IBookingFormData';

import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18n/avia-AviaBooking-validations';

export const birthdateValidation: TField = {
    name: EFieldName.birthdate,
    validation: {
        blur: [
            {
                type: EValidationType.validDate,
                params: HUMAN_DATE_RU,
                errorMessage: i18nBlock.invalidDashDate(),
            },
            {
                type: EValidationType.minDate,
                params: '01.01.1900',
                errorMessage: i18nBlock.minDashBirthDashYear({year: 1900}),
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.required(),
            },
        ],
    },
    dependentValidations: [
        /* Младенец */
        {
            conditions: [
                {
                    path: {fieldName: EAviaPassengerFieldName.ageCategory},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [EAgeCategory.infant],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.minDateFromField,
                        params: {
                            field: {
                                fieldGroupId: EFormGroup.flightInfo,
                                fieldName: EFlightInfoFieldName.departureDate,
                            },
                            offset: -2,
                            scale: 'year',
                            strict: true,
                            comparisonScale: 'day',
                        },
                        errorMessage:
                            i18nBlock.invalidDashInfantDashMaxDashAgeDashCategory(),
                    },
                    {
                        type: EValidationType.maxDateFromToday,
                        params: {
                            offset: 0,
                            scale: 'year',
                        },
                        errorMessage:
                            i18nBlock.invalidDashInfantDashMinDashAgeDashCategory(),
                    },
                ],
            },
        },
        /* Ребенок */
        {
            conditions: [
                {
                    path: {fieldName: EAviaPassengerFieldName.ageCategory},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [EAgeCategory.child],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.minDateFromField,
                        params: {
                            field: {
                                fieldGroupId: EFormGroup.flightInfo,
                                fieldName: EFlightInfoFieldName.departureDate,
                            },
                            offset: -12,
                            scale: 'year',
                            strict: true,
                            comparisonScale: 'day',
                        },
                        errorMessage:
                            i18nBlock.invalidDashChildDashMaxDashAgeDashCategory(),
                    },
                    {
                        type: EValidationType.maxDateFromToday,
                        params: {
                            offset: 0,
                            scale: 'year',
                        },
                        errorMessage:
                            i18nBlock.invalidDashChildDashMinDashAgeDashCategory(),
                    },
                ],
            },
        },
        /* Взрослый */
        {
            conditions: [
                {
                    path: {fieldName: EAviaPassengerFieldName.ageCategory},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [EAgeCategory.adult],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.maxDateFromField,
                        params: {
                            field: {
                                fieldGroupId: EFormGroup.flightInfo,
                                fieldName: EFlightInfoFieldName.departureDate,
                            },
                            offset: -12,
                            scale: 'year',
                            comparisonScale: 'day',
                        },
                        errorMessage:
                            i18nBlock.invalidDashAdultDashMinDashAgeDashCategory(),
                    },
                ],
            },
        },
    ],
};
