import {RUSSIAN_INTERNATIONAL_PASSPORT} from 'constants/document/documentTypes';
import {EFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';
import {EFormGroup} from 'projects/avia/pages/AviaBooking/types/IBookingFormData';
import {EFlightInfoFieldName} from 'projects/avia/pages/AviaBooking/types/IBookingFlightInfo';

import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18n/avia-AviaBooking-validations';

export const documentDateValidation: TField = {
    name: EFieldName.documentValidDate,
    validation: {
        blur: [
            {
                type: EValidationType.validDate,
                params: HUMAN_DATE_RU,
                errorMessage: i18nBlock.invalidDashDate(),
            },
            {
                type: EValidationType.minDateFromField,
                params: {
                    field: {
                        fieldGroupId: EFormGroup.flightInfo,
                        fieldName: EFlightInfoFieldName.departureDate,
                    },
                    offset: 0,
                    scale: 'day',
                },
                errorMessage: i18nBlock.expiredDashDocument(),
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_INTERNATIONAL_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.required,
                        params: true,
                        errorMessage: i18nBlock.required(),
                    },
                ],
            },
        },
    ],
};
