import {
    RUSSIAN_PASSPORT,
    RUSSIAN_INTERNATIONAL_PASSPORT,
    BIRTH_CERTIFICATE,
    DOCUMENT_OTHER,
} from 'constants/document/documentTypes';
import {EFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

import * as i18nBlock from 'i18n/avia-AviaBooking-validations';

export const documentNumberValidation: TField = {
    name: EFieldName.documentNumber,
    validation: {
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.required(),
            },
        ],
    },
    dependentValidations: [
        /* Паспорт РФ */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: '^\\d{2}\\d{2}\\d{6}$',
                        errorMessage: i18nBlock.invalidDashPassportDashNumber(),
                    },
                ],
            },
        },
        /* Загран РФ */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_INTERNATIONAL_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: '^\\d{9}$',
                        errorMessage:
                            i18nBlock.invalidDashInternationalDashPassportDashNumber(),
                    },
                ],
            },
        },
        /* Свидетельство о рождении */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [BIRTH_CERTIFICATE],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: '^((I{1,3}|IV|VI{0,3}|IX)|(X{1,2}(IX|IV|V?I{0,3}))|(XXXI{0,3}|XXXI?V))[А-Яа-яЁё]{2}\\d{6}$',
                        errorMessage:
                            i18nBlock.invalidDashBirthDashCertificateDashNumberDashCyrillic(),
                    },
                ],
            },
        },
        /* Другой документ */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [DOCUMENT_OTHER],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.minLength,
                        params: 6,
                        errorMessage: i18nBlock.minDashLength({count: 6}),
                    },
                    {
                        type: EValidationType.maxLength,
                        params: 14,
                        errorMessage: i18nBlock.maxDashLength({count: 14}),
                    },
                    {
                        type: EValidationType.regex,
                        params: '^[a-zA-Z0-9]+$',
                        errorMessage:
                            i18nBlock.latinDashAndDashNumberDashOnly(),
                    },
                ],
            },
        },
    ],
};
