import {EFieldName} from 'components/BookingContactsForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

import * as i18nBlock from 'i18n/avia-AviaBooking-validations';

const MAX_EMAIL_LENGTH = 59;

export const emailValidation: TField = {
    name: EFieldName.email,
    validation: {
        blur: [
            {
                type: EValidationType.maxLength,
                params: MAX_EMAIL_LENGTH,
                errorMessage: i18nBlock.maxDashLength({
                    count: MAX_EMAIL_LENGTH,
                }),
            },
            {
                type: EValidationType.regex,
                params: `^([—#$%&'*+-/=?^_\`{}|\\w]+)@([\\w-]+)\\.(\\w{2,})$`,
                errorMessage: i18nBlock.invalidDashEmail(),
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.required(),
            },
        ],
    },
};
