import {EFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

import * as i18nBlock from 'i18n/avia-AviaBooking-validations';

import {nameRegex, nameStrictRegex} from './common';

const MAX_LENGTH = 25;

export const firstNameValidation: TField = {
    name: EFieldName.firstName,
    validation: {
        blur: [
            {
                type: EValidationType.maxLength,
                params: MAX_LENGTH,
                errorMessage: i18nBlock.firstDashLetters({count: MAX_LENGTH}),
            },
            {
                type: EValidationType.regex,
                params: nameRegex,
                errorMessage: i18nBlock.latinDashOnly(),
            },
            {
                type: EValidationType.regex,
                params: nameStrictRegex,
                errorMessage: i18nBlock.invalidName(),
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.required(),
            },
        ],
    },
};
