import {TField} from 'types/common/validation/form';
import {EValidationType} from 'types/common/validation/validation';
import {
    EAviaLoyaltyCardFieldName,
    EAviaPassengerFieldName,
} from 'projects/avia/pages/AviaBooking/types/IBookingFormPassengersData';

import * as i18nBlock from 'i18n/aviaBookingForm';

export const loyaltyCardNumberValidation: TField = {
    name: `${EAviaPassengerFieldName.loyaltyCard}.${EAviaLoyaltyCardFieldName.number}`,
    validation: {
        blur: [
            {
                type: EValidationType.regex,
                params: '^\\d{4,10}$',
                errorMessage:
                    i18nBlock.loyaltyCardNumberLengthBetweenValidation(),
            },
        ],
    },
};
