import {EFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

import * as i18nBlock from 'i18n/avia-AviaBooking-validations';

import {nameRegex, nameStrictRegex} from './common';

const MAX_LENGTH = 29;

export const patronymicValidation: TField = {
    name: EFieldName.patronymicName,
    validation: {
        blur: [
            {
                type: EValidationType.maxLength,
                params: MAX_LENGTH,
                errorMessage: i18nBlock.firstDashLetters({count: MAX_LENGTH}),
            },
            {
                type: EValidationType.regex,
                params: nameRegex,
                errorMessage: i18nBlock.latinDashOnly(),
            },
            {
                type: EValidationType.regex,
                params: nameStrictRegex,
                errorMessage: i18nBlock.invalidName(),
            },
        ],
    },
    dependentValidations: [
        /* Если не выбран чекбокс отсутствия отчества */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.isPatronymicDisabled},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [false, null, undefined],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.required,
                        params: true,
                        errorMessage: i18nBlock.requiredDashPatronymic(),
                    },
                ],
            },
        },
    ],
};
