import {getPhoneValidationRegExp} from 'constants/form/validationRules';
import {EFieldName} from 'components/BookingContactsForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

import * as i18nBlock from 'i18n/avia-AviaBooking-validations';

const MAX_EMAIL_LENGTH = 100;

export const phoneValidation: TField = {
    name: EFieldName.phone,
    validation: {
        blur: [
            {
                type: EValidationType.maxLength,
                params: MAX_EMAIL_LENGTH,
                errorMessage: i18nBlock.maxDashLength({
                    count: MAX_EMAIL_LENGTH,
                }),
            },
            {
                type: EValidationType.regex,
                params: getPhoneValidationRegExp(10, 15),
                errorMessage: i18nBlock.invalidDashFreeDashPhone(),
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.required(),
            },
        ],
    },
};
