import {IBookingDocumentTypeWithTitle} from '../types/IBookingDocumentTypeWithTitle';

import * as localized from 'i18n/avia-AviaBooking-lib-documentUtils';

import {AviaDocumentType} from 'server/api/AviaBookingApi/enums/DocumentType';

type TDocumentsCollection = Readonly<
    Record<AviaDocumentType, IBookingDocumentTypeWithTitle>
>;

export const DOCUMENTS: TDocumentsCollection = {
    passport: {
        id: AviaDocumentType.PASSPORT,
        title: localized.passport(),
    },
    international_passport_ru: {
        id: AviaDocumentType.INTERNATIONAL_PASSPORT_RU,
        title: localized.internationalPassportRu(),
    },
    birth_certificate: {
        id: AviaDocumentType.BIRTH_CERTIFICATE,
        title: localized.birthCertificate(),
    },
    national_passport: {
        id: AviaDocumentType.NATIONAL_PASSPORT,
        title: localized.nationalPassport(),
    },
};

export const getDocumentTitle = (documentType: AviaDocumentType): string =>
    DOCUMENTS[documentType].title;
