/**
 * Возвращает список всех путей до свойств в заданном объекте.
 * Список ключей получается через Object.keys
 * @example
 * getFieldsFromValues({a: {b: c: [{e: 1}]}, d: 2}) // ['a.b.c.0.e', 'd']
 *
 * @param object - заданный объект
 */
export function getAllPaths<T extends {}>(object: T): string[] {
    const fields: string[] = [];
    const keys = Object.keys(object) as (keyof T)[];
    for (const key of keys) {
        const value = object[key];
        if (value && typeof value === 'object') {
            fields.push(...getAllPaths(value).map(x => `${key}.${x}`));
        } else {
            fields.push(key as string);
        }
    }
    return fields;
}
