import {FlightType} from '../types/FlightType';
import {EAgeCategory} from '../types/AgeCategoryType';
import {TAviaFormDocumentTypes} from 'server/api/AviaBookingApi/types/TAviaFormDocumentTypes';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

type TDocumentsCollection = Record<
    FlightType,
    Record<EAgeCategory, TAviaFormDocumentTypes[]>
>;

const {RU_NATIONAL_PASSPORT, RU_FOREIGN_PASSPORT, RU_BIRTH_CERTIFICATE, OTHER} =
    EDocumentType;

const DOCUMENTS_COLLECTION: TDocumentsCollection = {
    Internal: {
        adult: [
            RU_NATIONAL_PASSPORT,
            RU_FOREIGN_PASSPORT,
            RU_BIRTH_CERTIFICATE,
            OTHER,
        ],
        child: [RU_BIRTH_CERTIFICATE, RU_FOREIGN_PASSPORT, OTHER],
        infant: [RU_BIRTH_CERTIFICATE, RU_FOREIGN_PASSPORT, OTHER],
    },
    InternationalNoVisa: {
        adult: [RU_NATIONAL_PASSPORT, RU_FOREIGN_PASSPORT, OTHER],
        child: [RU_FOREIGN_PASSPORT, OTHER],
        infant: [RU_FOREIGN_PASSPORT, OTHER],
    },
    International: {
        adult: [RU_FOREIGN_PASSPORT, OTHER],
        child: [RU_FOREIGN_PASSPORT, OTHER],
        infant: [RU_FOREIGN_PASSPORT, OTHER],
    },
};

export function getFilteredDocuments(
    flightType: FlightType,
    ageCategory: EAgeCategory,
): TAviaFormDocumentTypes[] {
    return DOCUMENTS_COLLECTION[flightType][ageCategory];
}
