import first from 'lodash/first';
import last from 'lodash/last';

import {RU_GEO_ID} from 'constants/common';

import {FlightType} from '../types/FlightType';
import {IBookingSegmentModel} from 'server/services/AviaBookingService/variants/types';

const INTERNATIONAL_NO_VISA_COUNTRIES = [
    168, // Армения
    149, // Белоруссия
    159, // Казахстан
];

const INTERNATIONAL_NO_VISA_CITIES = [
    29386, // Абхазия
    29387, // Южная Осетия (нет аэропортов)
];

export function getFlightType(segments: IBookingSegmentModel[]): FlightType {
    const firstSegment = first(segments);
    const lastSegment = last(segments);

    // Пустого списка перелётов не должно быть
    // Добавляем проверку для безопасности
    if (!firstSegment || !lastSegment) {
        return 'Internal';
    }

    const firstFlight = first(firstSegment.flights);
    const lastFlight = last(lastSegment.flights);

    // Пустого списка перелётов не должно быть
    // Добавляем проверку для безопасности
    if (!firstFlight || !lastFlight) {
        return 'Internal';
    }

    const borderFlightDestinationCountries = [
        firstFlight.departureSettlement.countryId,
        lastFlight.arrivalSettlement.countryId,
    ];

    const borderFlightDestinationCities = [
        firstFlight.departureSettlement.id,
        lastFlight.arrivalSettlement.id,
    ];

    if (borderFlightDestinationCountries.every(x => x === RU_GEO_ID)) {
        return 'Internal';
    }

    if (borderFlightDestinationCountries.every(x => x !== RU_GEO_ID)) {
        return 'International';
    }

    if (
        borderFlightDestinationCountries.some(x =>
            INTERNATIONAL_NO_VISA_COUNTRIES.includes(x),
        ) ||
        borderFlightDestinationCities.some(x =>
            INTERNATIONAL_NO_VISA_CITIES.includes(x),
        )
    ) {
        return 'InternationalNoVisa';
    }

    return 'International';
}
