/**
 * Creates a new list with the separator interposed between elements.
 * from https://github.com/ramda/ramda/blob/v0.26.1/source/intersperse.js
 *
 * @param list - The list to be interposed
 * @param separator - The element to add to the list
 *
 * @returns {Array} The new list
 */
export function intersperse<S, L>(list: L[], separator: S): (S | L)[] {
    const out = [];
    let idx = 0;
    const length = list.length;
    while (idx < length) {
        if (idx === length - 1) {
            out.push(list[idx]);
        } else {
            out.push(list[idx], separator);
        }
        idx += 1;
    }
    return out;
}
