import {EAeroflotOrderState} from 'server/api/AviaBookingApi/enums/EAeroflotOrderState';

export function isErrorOrderState(
    state?: EAeroflotOrderState | null,
): state is
    | EAeroflotOrderState.OS_CANCELLED
    | EAeroflotOrderState.OS_UNHANDLED_ERROR {
    return (
        state === EAeroflotOrderState.OS_CANCELLED ||
        state === EAeroflotOrderState.OS_UNHANDLED_ERROR
    );
}

export function isFinalOrderState(state?: EAeroflotOrderState | null): boolean {
    return (
        state === EAeroflotOrderState.OS_CONFIRMED ||
        state === EAeroflotOrderState.OS_CANCELLED
    );
}
