import * as localized from 'i18n/avia-AviaBooking-lib-tariffOptionUtils';

const TARIFF_TYPES_DICT: ReadonlyMap<string, string> = new Map([
    ['baggage', localized.baggage()],
    ['carry_on', localized.carryOn()],
    ['miles', localized.miles()],
    ['refundable', localized.refundable()],
]);

export const tariffTypeToHumanReadable = (type: string) => {
    return TARIFF_TYPES_DICT.get(type) || type;
};
