import {
    TBookingContacts,
    TBookingContactErrors,
} from 'components/BookingContactsForm/BookingContactsForm';

import {IBookingFlightInfo} from './IBookingFlightInfo';
import {
    IBookingFormPassengersData,
    IBookingFormPassengersErrors,
} from './IBookingFormPassengersData';

export enum EFormGroup {
    passengers = 'passengers',
    contacts = 'contacts',
    flightInfo = 'flightInfo',
}

export interface IBookingFormData {
    [EFormGroup.passengers]?: IBookingFormPassengersData[];
    [EFormGroup.contacts]?: TBookingContacts;
    [EFormGroup.flightInfo]?: IBookingFlightInfo;
    marker?: string;
}

export interface IBookingFormErrors {
    [EFormGroup.passengers]?: Nullable<IBookingFormPassengersErrors>[];
    [EFormGroup.contacts]?: TBookingContactErrors;
}
