import {
    IFormDocument,
    TFormDocumentErrors,
} from 'components/BookingPassengerForm/types/IDocument';
import {TAviaFormDocumentTypes} from 'server/api/AviaBookingApi/types/TAviaFormDocumentTypes';
import {EAviaLoyaltyCardType} from 'types/avia/book/EAviaLoyaltyCardType';
import {IFieldError} from 'types/common/validation/form';

import {EAgeCategory} from './AgeCategoryType';

export enum EAviaPassengerFieldName {
    ageCategory = 'ageCategory',
    loyaltyCard = 'loyaltyCard',
}

export enum EAviaLoyaltyCardFieldName {
    type = 'type',
    number = 'number',
}

export interface IFormLoyaltyCard {
    [EAviaLoyaltyCardFieldName.type]: EAviaLoyaltyCardType | undefined;
    [EAviaLoyaltyCardFieldName.number]: string;
}

export interface IBookingFormPassengersData
    extends IFormDocument<TAviaFormDocumentTypes> {
    [EAviaPassengerFieldName.ageCategory]: EAgeCategory;
    citizenshipGeoId?: number;
    [EAviaPassengerFieldName.loyaltyCard]?: IFormLoyaltyCard;
}

export interface IBookingFormPassengersErrors extends TFormDocumentErrors {
    [EAviaPassengerFieldName.loyaltyCard]: {
        [EAviaLoyaltyCardFieldName.type]: IFieldError;
        [EAviaLoyaltyCardFieldName.number]: IFieldError;
    };
}
