import React from 'react';

import {useMobile} from 'utilities/hooks/useMobile';

import Box, {IBoxProps, TBoxSizes} from 'components/Box/Box';

import cx from './Badge.scss';

interface BadgeContentProps extends IBoxProps {}

interface Paddings {
    x: TBoxSizes;
    y: TBoxSizes;
}

function BadgeContent({x, y, children, ...props}: BadgeContentProps) {
    const isMobile = useMobile();
    const paddings: Paddings = isMobile ? {x: 2, y: 3} : {x: 3, y: 5};

    return (
        <Box
            // eslint-disable-next-line no-eq-null
            x={x == null ? paddings.x : x}
            // eslint-disable-next-line no-eq-null
            y={y == null ? paddings.y : y}
            {...props}
        >
            {children}
        </Box>
    );
}

interface BadgeProps {
    children?: React.ReactNode;
    style?: React.CSSProperties;
    className?: string;
}

function Badge({children, style, className}: BadgeProps) {
    return (
        <section className={cx('root', className)} style={style}>
            {children}
        </section>
    );
}

Badge.Content = BadgeContent;

export default Badge;
