import React from 'react';

import {IPassengers} from 'projects/avia/pages/AviaBooking/types/IPassengers';

import {DateLikeType} from 'utilities/dateUtils';
import {useMobile} from 'utilities/hooks/useMobile';
import humanizePeriod from 'utilities/dateUtils/humanizePeriod';

import Box from 'components/Box/Box';
import getPassengersText from 'projects/avia/pages/AviaBookingCreateOrder/AviaBookingOutdatedModal/components/SearchInfo/utilties/getPassengersText';

import Badge from '../Badge/Badge';

interface ISearchInfoProps {
    fromTitle: string | undefined;
    toTitle: string | undefined;
    fromDate: DateLikeType | undefined;
    toDate: DateLikeType | undefined;
    passengers: IPassengers;
}

export const SearchInfo: React.FC<ISearchInfoProps> = ({
    fromTitle,
    toTitle,
    fromDate,
    toDate,
    passengers,
}) => {
    const isMobile = useMobile();

    return (
        <Badge>
            <Badge.Content>
                <Box
                    textSize={isMobile ? 'm' : 'l'}
                    below={isMobile ? 0 : 1}
                    textWeight="bold"
                >
                    {fromTitle} — {toTitle}
                </Box>
                <Box textSize="m">
                    {fromDate && (
                        <div>
                            {humanizePeriod(fromDate, toDate || fromDate)}
                        </div>
                    )}
                    <div>{getPassengersText(passengers)}</div>
                </Box>
            </Badge.Content>
        </Badge>
    );
};
