import {IPassengers} from 'projects/avia/pages/AviaBooking/types/IPassengers';

import {
    formatCountOfAdults,
    formatCountOfChildren,
    formatCountOfInfants,
} from 'utilities/formatCount';

export default function getPassengersText({
    adults,
    children,
    infants,
}: IPassengers): string {
    return [
        adults > 0 && formatCountOfAdults(adults),
        children > 0 && formatCountOfChildren(children),
        infants > 0 && formatCountOfInfants(infants),
    ]
        .filter(Boolean)
        .join(', ');
}
