import {ValidationErrors} from 'final-form';

import {IBookingFormData} from 'projects/avia/pages/AviaBooking/types/IBookingFormData';

import getFirstNameValidationError from './getFirstNameValidationError';
import getPatronymicValidationError from './getPatronymicValidationError';
import getLoyaltyCardValidationError from './getLoyaltyCardValidationError';

export default function bookingFormCustomValidation(
    values: IBookingFormData,
): ValidationErrors {
    if (!values.passengers) {
        return {};
    }

    let isSomePassengersError = false;

    const passengersErrors = values.passengers.map(
        (passenger, _, passengers) => {
            const firstNameError = getFirstNameValidationError(
                passenger.firstName,
                passenger.patronymicName,
            );

            const patronymicError = getPatronymicValidationError(
                passenger.firstName,
                passenger.patronymicName,
            );

            const loyaltyCardError = getLoyaltyCardValidationError(
                passenger.loyaltyCard,
                passengers,
            );

            if (firstNameError || patronymicError || loyaltyCardError) {
                isSomePassengersError = true;
            }

            return {
                firstName: firstNameError,
                patronymicName: patronymicError,
                loyaltyCard: {
                    number: loyaltyCardError,
                },
            };
        },
    );

    return {
        ...(isSomePassengersError ? {passengers: passengersErrors} : {}),
    };
}
