import {isNotNullable} from 'types/utilities';
import {
    IBookingFormPassengersData,
    IFormLoyaltyCard,
} from 'projects/avia/pages/AviaBooking/types/IBookingFormPassengersData';

import * as i18nBlock from 'i18n/avia-AviaBooking-validations';

export default function getLoyaltyCardValidationError(
    loyaltyCard: IFormLoyaltyCard | undefined,
    passengers: IBookingFormPassengersData[],
): string {
    if (!loyaltyCard?.number) {
        return '';
    }

    const {type, number} = loyaltyCard;

    const sameLoyaltyCardNumbers = passengers
        .map(passenger => passenger.loyaltyCard)
        .filter(
            card =>
                isNotNullable(card) &&
                card.number === number &&
                card.type === type,
        );

    if (sameLoyaltyCardNumbers.length > 1) {
        return i18nBlock.equalDashLoyaltyDashCardDashNumber();
    }

    return '';
}
