import isFirstNameAndPatronymicValidSumLength from 'projects/avia/pages/AviaBookingCreateOrder/utilities/bookingFormCustomValidation/isFirstNameAndPatronymicValidSumLength';

import * as i18nBlock from 'i18n/avia-AviaBooking-validations';

export default function getPatronymicValidationError(
    firstName: string | undefined,
    patronymic: string | undefined,
): string {
    if (!patronymic) {
        return '';
    }

    if (!isFirstNameAndPatronymicValidSumLength(firstName, patronymic)) {
        return i18nBlock.firstNameAndPatronymicMaxLength();
    }

    return '';
}
