import React from 'react';

import {useMobile} from 'utilities/hooks/useMobile';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as localized from 'i18n/avia-AviaBooking-AviaBookingOrderPNR';

import Card from 'components/Card/Card';

import cx from './AviaBookingOrderPNR.scss';

interface IAviaBookingOrderPNRProps extends IWithQaAttributes {
    pnr?: string;
}

const AviaBookingOrderPNR: React.FC<IAviaBookingOrderPNRProps> = props => {
    const isMobile = useMobile();

    return (
        <Card
            x={isMobile ? 3 : 8}
            y={4}
            className={cx('root', isMobile && 'root_mobile')}
            {...prepareQaAttributes(props)}
        >
            <span className={cx('label')}>{localized.label()}</span>{' '}
            <strong
                {...prepareQaAttributes({
                    parent: props,
                    current: 'number',
                })}
            >
                {props.pnr}
            </strong>
        </Card>
    );
};

export default React.memo(AviaBookingOrderPNR);
