import React, {useMemo} from 'react';

import {EProjectName} from 'constants/common';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import BookingSegmentsInfo from 'projects/avia/pages/AviaBooking/components/BookingSegmentsInfo/BookingSegmentsInfo';
import {BookingTravellerList} from 'projects/avia/pages/AviaBookingOrder/components/BookingTravellerList/BookingTravellerList';
import AviaBookingOrderPNR from 'projects/avia/pages/AviaBookingOrder/components/AviaBookingOrderPNR/AviaBookingOrderPNR';
import AviaBookingOrderUserContacts from 'projects/avia/pages/AviaBookingOrder/components/AviaBookingOrderUserContacts/AviaBookingOrderUserContacts';
import TariffsModal from 'projects/avia/pages/AviaBooking/components/TariffsField/components/TariffsModal/TariffsModal';
import OrderHeader from 'components/OrderHeader/OrderHeader';
import OrderWrapper from 'projects/account/pages/Order/components/OrderWrapper/OrderWrapper';

import {IAviaBookingOrderPageData} from 'server/services/AviaBookingService/order/IAviaBookingOrderPageData';

interface IAviaBookingOrderPageViewProps {
    order: IAviaBookingOrderPageData;
}

const ID = 'some_id';

const ROOT_QA = 'aviaAccountOrderPage';

export const AviaBookingOrderPageView: React.FC<IAviaBookingOrderPageViewProps> =
    props => {
        const {
            order: {
                segments,
                prettyOrderId,
                tripId,
                travellers,
                price,
                pnr,
                email,
                phone,
                displayState,
            },
        } = props;
        const deviceType = useDeviceType();

        const variants = useMemo(() => [{segments, id: ID}], [segments]);

        return (
            <OrderWrapper {...prepareQaAttributes(ROOT_QA)}>
                <Box below={deviceType.isMobile ? 4 : 5}>
                    <OrderHeader
                        type={EProjectName.AVIA}
                        number={prettyOrderId}
                        tripId={tripId}
                        displayState={displayState}
                    />
                </Box>
                <Box below={deviceType.isMobile ? 2 : 3}>
                    <AviaBookingOrderPNR
                        pnr={pnr}
                        {...prepareQaAttributes({
                            parent: ROOT_QA,
                            current: 'pnr',
                        })}
                    />
                </Box>
                <Box below={deviceType.isDesktop ? 5 : 2}>
                    <BookingSegmentsInfo
                        segments={segments}
                        withBaggage
                        {...prepareQaAttributes(ROOT_QA)}
                    />
                </Box>
                <Box below={deviceType.isDesktop ? 5 : 2}>
                    <BookingTravellerList
                        travellers={travellers}
                        price={price}
                        {...prepareQaAttributes({
                            parent: ROOT_QA,
                            current: 'travellerList',
                        })}
                    />
                </Box>
                <AviaBookingOrderUserContacts
                    email={email}
                    phone={phone}
                    {...prepareQaAttributes({
                        parent: ROOT_QA,
                        current: 'contacts',
                    })}
                />
                <TariffsModal variants={variants} variantToken={ID} />
            </OrderWrapper>
        );
    };
