import React from 'react';
import {conformToMask} from 'react-text-mask';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as localized from 'i18n/avia-AviaBookingOrder-AviaBookingOrderUserContacts';

import OrderContacts from 'projects/account/pages/Order/components/OrderContacts/OrderContacts';

const PHONE_MASK = [
    '+',
    /\d/,
    ' ',
    /\d/,
    /\d/,
    /\d/,
    ' ',
    /\d/,
    /\d/,
    /\d/,
    '-',
    /\d/,
    /\d/,
    '-',
    /\d/,
    /\d/,
];

interface IAviaBookingOrderUserContactsProps extends IWithQaAttributes {
    email: string;
    phone: string;
}

const AviaBookingOrderUserContacts: React.FC<IAviaBookingOrderUserContactsProps> =
    props => {
        const {email, phone} = props;

        return (
            <OrderContacts
                email={email}
                phone={conformToMask(phone, PHONE_MASK, {}).conformedValue}
                info={localized.comment()}
                {...prepareQaAttributes(props)}
            />
        );
    };

export default AviaBookingOrderUserContacts;
