import {connect} from 'react-redux';
import {RouteComponentProps} from 'react-router-dom';

import {ICompositeOrderStateDTO} from 'server/api/AviaBookingApi/types/ICompositeOrderStateDTO';
import {IBookingVariantsModelType} from 'server/services/AviaBookingService/variants/types';

import {requestVariant} from 'reducers/avia/booking/variants/actions';
import {
    startStatePolling,
    stopStatePolling,
} from 'reducers/avia/booking/compositeStates/actions';
import {initOrderPayment} from 'reducers/avia/booking/orderPayment/actions';
import {requestOrder} from 'reducers/avia/booking/orders/actions';
import {StoreInterface} from 'reducers/storeTypes';
import {AviaBookingOrdersResource} from 'reducers/avia/booking/orders/reducer';

import {bookingPaymentSelector} from 'projects/avia/pages/AviaBookingPayment/bookingPaymentSelector';

import {BookingPayment} from './BookingPayment';

export interface IBookingPaymentRouteParams {
    token: string;
    orderId: string;
}

export interface IBookingPaymentOwnProps
    extends RouteComponentProps<IBookingPaymentRouteParams> {}

export interface IBookingPaymentStateProps {
    variants: IBookingVariantsModelType | null;
    compositeState: ICompositeOrderStateDTO | null;
    pageIsLoading: boolean;
    orderResource: AviaBookingOrdersResource | undefined;
    paymentIsFailed: boolean;
}

export interface IBookingPaymentDispatchProps {
    requestVariants: typeof requestVariant;
    startStatePolling: typeof startStatePolling;
    stopStatePolling: typeof stopStatePolling;
    initPayment: typeof initOrderPayment;
    requestOrder: typeof requestOrder;
}

export const BookingPaymentContainer = connect<
    IBookingPaymentStateProps,
    IBookingPaymentDispatchProps,
    IBookingPaymentOwnProps,
    StoreInterface
>(bookingPaymentSelector, {
    requestVariants: requestVariant,
    startStatePolling,
    stopStatePolling,
    initPayment: initOrderPayment,
    requestOrder,
})(BookingPayment);
