import {RouteComponentProps} from 'react-router-dom';

import {StoreInterface} from 'reducers/storeTypes';
import {EOrderPaymentStatus} from 'reducers/avia/booking/orderPayment/reducer';

import {
    getAviaBookingVariant,
    getAviaBookingCompositeState,
    getAviaBookingOrder,
    getOrderPaymentStatus,
} from 'selectors/avia/aviaBooking';

import {
    IBookingPaymentRouteParams,
    IBookingPaymentStateProps,
} from './BookingPaymentContainer';

export const bookingPaymentSelector = (
    state: StoreInterface,
    props: RouteComponentProps<IBookingPaymentRouteParams>,
): IBookingPaymentStateProps => {
    const {orderId, token} = props.match.params;

    const variantsState = getAviaBookingVariant(state, token);

    const compositeState = getAviaBookingCompositeState(state, orderId);

    const orderResource = getAviaBookingOrder(state, orderId);

    const orderPaymentStatus = getOrderPaymentStatus(state);

    const pageIsLoading = !variantsState || variantsState.loading;
    const paymentIsFailed =
        orderPaymentStatus === EOrderPaymentStatus.Failed ||
        orderPaymentStatus === EOrderPaymentStatus.PollingFailed;

    return {
        variants: variantsState && variantsState.variants,
        compositeState: compositeState && compositeState.compositeState,
        pageIsLoading,
        orderResource,
        paymentIsFailed,
    };
};
