import React, {useEffect} from 'react';

import {
    SOLOMON_AVIA_PAYMENT_PAGE_LOADED,
    SOLOMON_AVIA_TRUST_ERROR,
    SOLOMON_AVIA_TRUST_LOADED,
    SOLOMON_AVIA_TRUST_SUCCESS,
} from 'constants/solomon';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {useBoolean} from 'utilities/hooks/useBoolean';
import {sendPaymentCounter} from 'utilities/solomon';
import {useReachGoal} from 'utilities/metrika/useReachGoal';
import {useExperiments} from 'utilities/hooks/useExperiments';

import PaymentIframe from 'components/PaymentIframe/PaymentIframe';
import AviaPaymentLayout from 'projects/avia/pages/AviaBookingPayment/components/AviaPaymentLayout/AviaPaymentLayout';

import {IAviaBookingOrderPageData} from 'server/services/AviaBookingService/order/IAviaBookingOrderPageData';

interface IBookingPaymentsScreenProps {
    order: IAviaBookingOrderPageData | null | undefined;
    paymentUrl?: string;
}

export const BookingPaymentsScreen: React.FC<IBookingPaymentsScreenProps> = ({
    order,
    paymentUrl,
}) => {
    const {value: paymentIsDone, setTrue: setPaymentIsDone} = useBoolean(false);
    const {value: iframeReady, setTrue: setReadyTrue} = useBoolean(false);
    const {value: paymentIsStarted, setTrue: setPaymentIsStarted} =
        useBoolean(false);
    const {aviaNewTrustForm} = useExperiments();

    useEffect(() => {
        sendPaymentCounter(SOLOMON_AVIA_PAYMENT_PAGE_LOADED);
    }, []);

    const handleSubmitPaymentForm = useReachGoal(
        EAviaGoal.BOY_PAYMENT_PAGE_PAY_BUTTON,
    );

    const handleLoadPaymentForm = useReachGoal(
        EAviaGoal.BOY_PAYMENT_PAGE_FORM_LOAD,
    );

    return (
        <AviaPaymentLayout
            order={order}
            paymentIsStarted={paymentIsStarted}
            loading={!iframeReady || paymentIsDone}
        >
            {paymentUrl && (
                <PaymentIframe
                    isNewTrust={Boolean(aviaNewTrustForm)}
                    loadEvent={SOLOMON_AVIA_TRUST_LOADED}
                    successEvent={SOLOMON_AVIA_TRUST_SUCCESS}
                    errorEvent={SOLOMON_AVIA_TRUST_ERROR}
                    paymentUrl={paymentUrl}
                    onLoad={setReadyTrue}
                    onFrameLoaded={handleLoadPaymentForm}
                    onStartPayment={setPaymentIsStarted}
                    onFinishPayment={setPaymentIsDone}
                    onBeforeSubmit={handleSubmitPaymentForm}
                    {...prepareQaAttributes('avia-booking-payment-frame')}
                />
            )}
        </AviaPaymentLayout>
    );
};
