import React from 'react';
import moment from 'moment';

import {EProjectName} from 'constants/common';

import {
    CHAR_EM_DASH,
    CHAR_EN_DASH,
    CHAR_LIST_MARKER,
    CHAR_NBSP,
} from 'utilities/strings/charCodes';
import {HUMAN_SHORT} from 'utilities/dateUtils/formats';

import * as i18nCommonPlural from 'i18n/common-plural';

import NewPaymentLayout from 'components/Layouts/NewPaymentLayout/PaymentLayout';

import {IAviaBookingOrderPageData} from 'server/services/AviaBookingService/order/IAviaBookingOrderPageData';

const SEPARATOR = `${CHAR_NBSP}${CHAR_EM_DASH}${CHAR_NBSP}`;

export interface IPaymentOrderInfo {
    order: IAviaBookingOrderPageData;
}

/**
 * Данные о заказе для новой формы траста.
 */
const PaymentOrderInfo: React.FC<IPaymentOrderInfo> = ({
    order: {segments, travellers, prettyOrderId},
}) => {
    const firstFlightForward = segments[0].flights[0];
    const lastFlightForward =
        segments[0].flights[segments[0].flights.length - 1];
    const lastSegment =
        segments.length > 1 ? segments[segments.length - 1] : undefined;
    const firstFlightBackward = lastSegment
        ? lastSegment.flights[0]
        : undefined;
    const lastFlightBackward = lastSegment
        ? lastSegment.flights[lastSegment.flights.length - 1]
        : undefined;

    const fromCity = firstFlightForward.departureSettlement.title;
    const toCity = lastFlightForward.arrivalSettlement.title;
    const backwardCity = lastFlightBackward?.arrivalSettlement.title;

    const settlements = `${fromCity}${SEPARATOR}${toCity}${
        backwardCity ? `${SEPARATOR}${backwardCity}` : ''
    }`;

    const forwardMoment = moment(firstFlightForward.departureDate);
    const backwardMoment = firstFlightBackward
        ? moment(firstFlightBackward.departureDate)
        : undefined;
    const dates = `${forwardMoment.format(HUMAN_SHORT)}${
        backwardMoment
            ? `${CHAR_NBSP}${CHAR_EN_DASH}${CHAR_NBSP}${backwardMoment.format(
                  HUMAN_SHORT,
              )}`
            : ''
    }`;

    const passengers = i18nCommonPlural.passengers({
        count: travellers.length,
    });

    return (
        <NewPaymentLayout.PaymentOrderInfo
            descriptionGeneral={settlements}
            descriptionAdditional={`${dates}${CHAR_NBSP}${CHAR_NBSP}${CHAR_LIST_MARKER}${CHAR_NBSP}${CHAR_NBSP}${passengers}`}
            separateDescription
            orderType={EProjectName.AVIA}
            orderId={prettyOrderId}
        />
    );
};

export default React.memo(PaymentOrderInfo);
