import React, {useCallback} from 'react';
import {RouteComponentProps} from 'react-router-dom';

import {PAYMENT_REDIRECT_TARGET_LOADED} from 'projects/avia/pages/AviaBookingPaymentRedirectTarget/utilities/constants';

import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';

import FinishPayment from 'components/Layouts/PaymentFinish/PaymentFinish';

export const AviaBookingPaymentRedirectTarget: React.FC<RouteComponentProps> =
    props => {
        const {location} = props;

        const handleMount = useCallback(() => {
            try {
                const {status} = getQueryByLocation(location);
                const success = status === '1';

                /**
                 * https://st.yandex-team.ru/TRAVELFRONT-4438#5fbe97778bf7c5141533c85a
                 */
                window.top?.postMessage(
                    {
                        type: PAYMENT_REDIRECT_TARGET_LOADED,
                        payload: {success},
                    },
                    '*',
                );
            } catch (e) {
                console.error(e);
            }
        }, [location]);

        return <FinishPayment onMount={handleMount} />;
    };
