import {PAYMENT_REDIRECT_TARGET_LOADED} from './constants';

export default interface IRedirectTargetLoadedMessage {
    type: typeof PAYMENT_REDIRECT_TARGET_LOADED;
    payload: {
        success: boolean;
    };
}

export function isRedirectTargetLoadedMessage(
    candidate: unknown,
): candidate is IRedirectTargetLoadedMessage {
    return Boolean(
        typeof candidate === 'object' &&
            candidate &&
            'type' in candidate &&
            // @ts-ignore
            candidate.type === PAYMENT_REDIRECT_TARGET_LOADED &&
            'payload' in candidate &&
            // @ts-ignore
            typeof candidate.payload === 'object',
    );
}
