import {connect} from 'react-redux';
import _flow from 'lodash/flow';
import {withRouter, RouteComponentProps} from 'react-router-dom';

import {IBookOrderIdRouteMatch} from 'types/avia/book/IBookOrderIdRouteMatch';

import {
    getHappyPageActions,
    TGetHappyPageRequestAction,
} from 'reducers/happyPage/actions';
import {StoreInterface} from 'reducers/storeTypes';
import {setIsNewTrip} from 'reducers/trips/tripPage/actions';

import aviaHappyPageSelector from 'selectors/happyPage/aviaHappyPageSelector';

import deviceTypeProvider, {
    IDeviceTypeProvider,
} from 'components/DeviceTypeProvider/DeviceTypeProvider';

import AviaHappyPage from './AviaHappyPage';

const mapStateToProps = aviaHappyPageSelector;
const mapDispatchToProps = {
    fetchHappyPageInfo: getHappyPageActions.request,
    setIsNewTrip,
};

type TAviaHappyPageStatePropsContainer = ReturnType<
    typeof aviaHappyPageSelector
>;

interface IAviaHappyPageDispatchPropsContainer {
    fetchHappyPageInfo: TGetHappyPageRequestAction;
    setIsNewTrip: typeof setIsNewTrip;
}

export type TAviaHappyPagePropsContainer = TAviaHappyPageStatePropsContainer &
    IAviaHappyPageDispatchPropsContainer &
    RouteComponentProps<IBookOrderIdRouteMatch> &
    IDeviceTypeProvider;

export default _flow(
    withRouter,
    connect<
        TAviaHappyPageStatePropsContainer,
        IAviaHappyPageDispatchPropsContainer,
        RouteComponentProps,
        StoreInterface
    >(mapStateToProps, mapDispatchToProps),
    deviceTypeProvider,
)(AviaHappyPage);
