import {ReactElement, useCallback, useMemo} from 'react';

import {EProjectName} from 'constants/common';
import {URLs} from 'constants/urls';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {
    IWithDataQaAttribute,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/happyPage';

import {TErrorActionType} from 'components/ErrorModal/ErrorModal';
import AviaHappyPageErrorModalLayout from 'projects/avia/pages/AviaHappyPage/components/AviaHappyPageErrorModalLayout/AviaHappyPageErrorModalLayout';

import cx from './AviaHappyPageErrorModal.scss';

interface IAviaHappyPageErrorModalProps extends IWithDataQaAttribute {
    pnr?: string;

    onMount?(): void;
}

const AviaHappyPageErrorModal = (
    props: IAviaHappyPageErrorModalProps,
): ReactElement => {
    const {pnr, onMount} = props;

    const handleReloadButtonClick = useCallback(() => {
        window.document.location.reload();
    }, []);

    const primaryAction = useMemo<TErrorActionType>(
        () => ({
            type: 'button',
            title: i18nBlock.aviaErrorModalReloadButton(),
            handler: handleReloadButtonClick,
        }),
        [handleReloadButtonClick],
    );

    const secondaryAction = useMemo<TErrorActionType>(
        () => ({
            type: 'button-link',
            title: i18nBlock.aviaErrorModalIndexLink(),
            props: {
                to: URLs[EProjectName.AVIA],
            },
        }),
        [],
    );

    return (
        <AviaHappyPageErrorModalLayout
            title={i18nBlock.aviaErrorModalTitle()}
            primaryAction={primaryAction}
            secondaryAction={secondaryAction}
            onMount={onMount}
            {...prepareQaAttributes(props)}
        >
            {insertJSXIntoKey(i18nBlock.aviaErrorModalMainText)({
                supportPhoneNode: (
                    <span className={cx('supportPhone')}>
                        {i18nBlock.aviaSupportPhone()}
                    </span>
                ),
            })}
            {Boolean(pnr) && (
                <div>
                    {insertJSXIntoKey(i18nBlock.aviaErrorModalPnr)({
                        pnrNode: pnr,
                    })}
                </div>
            )}
        </AviaHappyPageErrorModalLayout>
    );
};

export default AviaHappyPageErrorModal;
