import React, {PropsWithChildren, ReactElement} from 'react';

import {EProjectName} from 'constants/common';

import {
    IWithDataQaAttribute,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';
import ErrorModal, {TErrorActionType} from 'components/ErrorModal/ErrorModal';
import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

import cx from './AviaHappyPageErrorModalLayout.scss';

export interface IAviaHappyPageErrorModalLayoutProps
    extends IWithDataQaAttribute {
    /*
     * Срабатывает при маунте модалки
     */
    onMount?(): void;

    /*
     * Кнопка основного действия
     */
    primaryAction: TErrorActionType;

    /*
     * Кнопка второстепенного действия
     */
    secondaryAction?: TErrorActionType;

    /*
     * Заголовок попапа
     */
    title: string;
}

const AviaHappyPageErrorModalLayout = (
    props: PropsWithChildren<IAviaHappyPageErrorModalLayoutProps>,
): ReactElement => {
    const {onMount, primaryAction, secondaryAction, title, children} = props;

    return (
        <LayoutDefault
            isFixedNavigation
            hasSideSheetNavigation
            showNavigation
            showHeader
            showFooter
            searchFormInitialIsExpanded={false}
            project={EProjectName.AVIA}
        >
            <ErrorModal
                title={title}
                isVisible
                primaryAction={primaryAction}
                secondaryAction={secondaryAction}
                onMount={onMount}
                {...prepareQaAttributes(props)}
            >
                <Flex className={cx('content')}>
                    <Text size="m" color="primary">
                        {children}
                    </Text>
                </Flex>
            </ErrorModal>
        </LayoutDefault>
    );
};

export default React.memo(AviaHappyPageErrorModalLayout);
