import React, {useMemo} from 'react';
import {useLocation} from 'react-router-dom';

import {
    IWithDataQaAttribute,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {aviaURLs} from 'projects/avia/lib/urls';
import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';

import * as i18nBlock from 'i18n/happyPage';

import {TErrorActionType} from 'components/ErrorModal/ErrorModal';
import AviaHappyPageErrorModalLayout from 'projects/avia/pages/AviaHappyPage/components/AviaHappyPageErrorModalLayout/AviaHappyPageErrorModalLayout';

interface IAviaHappyPagePaymentErrorPageProps extends IWithDataQaAttribute {
    onPrimaryAction?: () => void;

    onMount?: () => void;
}

const AviaHappyPagePaymentErrorModal: React.FC<IAviaHappyPagePaymentErrorPageProps> =
    props => {
        const {onPrimaryAction, onMount} = props;
        const location = useLocation();
        const query = getQueryByLocation(location) as Record<string, string>;
        const token = query.token;

        const primaryAction = useMemo<TErrorActionType>(
            () => ({
                type: 'button-link',
                title: i18nBlock.aviaPaymentErrorRetryButton(),
                props: {
                    to: aviaURLs.getBookingFormUrl(token, query),
                },
                handler: onPrimaryAction,
            }),
            [onPrimaryAction, query, token],
        );

        return (
            <AviaHappyPageErrorModalLayout
                title={i18nBlock.aviaPaymentErrorTitle()}
                primaryAction={primaryAction}
                {...prepareQaAttributes(props)}
                onMount={onMount}
            >
                {i18nBlock.aviaPaymentErrorText()}
            </AviaHappyPageErrorModalLayout>
        );
    };

export default React.memo(AviaHappyPagePaymentErrorModal);
