import {ReactElement} from 'react';

import {IAviaOrderFlight} from 'types/avia/book/IAviaOrderFlight';
import {IWithClassName} from 'types/withClassName';

import {useMobile} from 'utilities/hooks/useMobile';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

interface IAviaOrderSegmentSettlementsProps extends IWithClassName {
    firstSegmentFlight: IAviaOrderFlight;
    lastSegmentFlight: IAviaOrderFlight;
}

const AviaOrderSegmentSettlements = (
    props: IAviaOrderSegmentSettlementsProps,
): ReactElement => {
    const {className, firstSegmentFlight, lastSegmentFlight} = props;
    const isMobile = useMobile();

    return (
        <Flex
            className={className}
            alignItems="center"
            justifyContent="space-between"
        >
            <Text size="m" weight={isMobile ? 'normal' : 'bold'}>
                {firstSegmentFlight.departureSettlement.title}
            </Text>
            <Text size="m" weight={isMobile ? 'normal' : 'bold'}>
                {lastSegmentFlight.arrivalSettlement.title}
            </Text>
        </Flex>
    );
};

export default AviaOrderSegmentSettlements;
