import {ReactElement} from 'react';

import {IAviaOrderSegment} from 'types/avia/book/IAviaOrderSegment';
import {IWithClassName} from 'types/withClassName';

import {getSegmentSettlementTitle} from './utilities/getSegmentSettlementTitle';
import {getSegmentDepartureDate} from './utilities/getSegmentDepartureDate';
import {useMobile} from 'utilities/hooks/useMobile';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

import cx from './AviaOrderSegmentTitle.scss';

interface IAviaOrderSegmentTitleProps extends IWithClassName {
    segment: IAviaOrderSegment;
}

const AviaOrderSegmentTitle = (
    props: IAviaOrderSegmentTitleProps,
): ReactElement => {
    const {segment, className} = props;
    const isMobile = useMobile();
    const settlementTitle = getSegmentSettlementTitle(segment);
    const departureDateTitle = getSegmentDepartureDate(segment);

    return (
        <Flex
            className={className}
            flexDirection={isMobile ? 'column' : 'row'}
            alignItems={isMobile ? 'flex-start' : 'center'}
        >
            <Text
                className={cx('settlementTitle')}
                size={isMobile ? 'l' : 'xl'}
                weight="bold"
            >
                {settlementTitle}
            </Text>
            <Text size={isMobile ? 'm' : 'xl'}>{departureDateTitle}</Text>
        </Flex>
    );
};

export default AviaOrderSegmentTitle;
