import _first from 'lodash/first';

import {IAviaOrderSegment} from 'types/avia/book/IAviaOrderSegment';

import {formatDate} from 'utilities/dateUtils';
import {HUMAN_WITH_WEEK} from 'utilities/dateUtils/formats';

export const getSegmentDepartureDate = (
    segment: IAviaOrderSegment,
): string | null => {
    const firstFlight = _first(segment.flights);

    if (!firstFlight) {
        return null;
    }

    return formatDate(firstFlight.departureDate, HUMAN_WITH_WEEK);
};
