import _first from 'lodash/first';
import _last from 'lodash/last';

import {IAviaOrderSegment} from 'types/avia/book/IAviaOrderSegment';

import {CHAR_EM_DASH} from 'utilities/strings/charCodes';

export const getSegmentSettlementTitle = (
    segment: IAviaOrderSegment,
): string | null => {
    const firstFlight = _first(segment.flights);
    const lastFlight = _last(segment.flights);

    if (!firstFlight || !lastFlight) {
        return null;
    }

    return `${firstFlight.departureSettlement.title} ${CHAR_EM_DASH} ${lastFlight.arrivalSettlement.title}`;
};
