import {ReactElement} from 'react';

import {IAviaOrderFlight} from 'types/avia/book/IAviaOrderFlight';
import {IWithClassName} from 'types/withClassName';

import AviaOrderFlightsTransferInfo from '../AviaOrderFlightsTransferInfo/AviaOrderFlightsTransferInfo';

interface IAviaOrderSegmentTransferInfoProps extends IWithClassName {
    flights: IAviaOrderFlight[];
}

const AviaOrderSegmentTransferInfo = (
    props: IAviaOrderSegmentTransferInfoProps,
): ReactElement | null => {
    const {flights, className} = props;

    if (flights.length === 1) {
        return null;
    }

    return (
        <div className={className}>
            {flights.map((flight, flightIndex) => {
                if (flightIndex === flights.length - 1) {
                    return null;
                }

                return (
                    <AviaOrderFlightsTransferInfo
                        key={flightIndex}
                        arrivalFlight={flights[flightIndex]}
                        departureFlight={flights[flightIndex + 1]}
                    />
                );
            })}
        </div>
    );
};

export default AviaOrderSegmentTransferInfo;
