import {ReactElement, useEffect} from 'react';

import {IAviaOrderSegment} from 'types/avia/book/IAviaOrderSegment';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Separator from 'components/Separator/Separator';
import Intersperse from 'components/Intersperse/Intersperse';

import AviaOrderSegment from '../AviaOrderSegment/AviaOrderSegment';

import cx from './AviaOrderSegments.scss';

interface IAviaOrderSegmentsProps extends IWithClassName {
    segments: IAviaOrderSegment[];
    onMount?(): void;
}

const AviaOrderSegments = (props: IAviaOrderSegmentsProps): ReactElement => {
    const {className, segments, onMount} = props;
    const deviceType = useDeviceType();

    useEffect(() => {
        onMount?.();
    }, [onMount]);

    return (
        <div className={cx(deviceMods('root', deviceType), className)}>
            <Intersperse separator={<Separator className={cx('separator')} />}>
                {segments.map((segment, index) => (
                    <AviaOrderSegment key={index} segment={segment} />
                ))}
            </Intersperse>
        </div>
    );
};

export default AviaOrderSegments;
