import {ServerDataFetcherBag} from 'server/redux/types';

import {IAviaRequestFlightsToDataAction} from 'reducers/avia/flightsTo/actions';

import fetchAviaFlightsToData from 'server/redux/avia/fetchFlightsToData';
import {
    prefillAviaContextFromFlightsToData,
    prefillAviaSearchFormFlightsToData,
} from 'server/redux/avia/prefillSearchForm';
import {fetchGeoPointWithAirport} from 'server/redux/avia/fetchGeoPointWithAirport';

export function prefetchData({toSlug}: IAviaRequestFlightsToDataAction) {
    return async function (serverFetcherData: ServerDataFetcherBag) {
        await Promise.all([
            fetchAviaFlightsToData(serverFetcherData, toSlug),
            fetchGeoPointWithAirport(serverFetcherData),
        ]);
        await Promise.all([
            prefillAviaSearchFormFlightsToData(serverFetcherData),
            prefillAviaContextFromFlightsToData(serverFetcherData),
        ]);
    };
}
