import {USER_SETTLEMENT} from 'projects/avia/constants/constants';

import {ServerDataFetcherBag} from 'server/redux/types';

import {IAviaRequestRouteDataAction} from 'reducers/avia/route/actions';

import {redirect} from 'projects/avia/pages/AviaLanding/utilities/redirect';

import {
    prefillAviaContextFromRouteData,
    prefillAviaSearchFormRouteData,
} from 'server/redux/avia/prefillSearchForm';
import fetchAviaRouteData from 'server/redux/avia/fetchRouteData';

function isRedirect({fromSlug, toSlug}: IAviaRequestRouteDataAction): boolean {
    return [fromSlug, toSlug].includes(USER_SETTLEMENT);
}

export function prefetchData(slugs: IAviaRequestRouteDataAction) {
    const {fromSlug, toSlug} = slugs;

    return async function (
        serverFetcherData: ServerDataFetcherBag,
    ): Promise<void> {
        if (isRedirect(slugs)) {
            await redirect(serverFetcherData, slugs);
        } else {
            await fetchAviaRouteData(serverFetcherData, fromSlug, toSlug);
            await Promise.all([
                prefillAviaSearchFormRouteData(serverFetcherData),
                prefillAviaContextFromRouteData(serverFetcherData),
            ]);
        }
    };
}
