import React from 'react';
import {useSelector} from 'react-redux';

import nonceSelector from 'selectors/common/nonceSelector';

import {useMobile} from 'utilities/hooks/useMobile';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import SchemaMarkup, {
    getMetaBreadcrumbList,
} from 'components/SchemaMarkup/SchemaMarkup';
import {IAviaRouteBreadcrumbs} from 'projects/avia/pages/AviaLanding/components/Breadcrumbs/IAviaRouteBreadcrumbs';
import AviaRouteBreadcrumbsDesktop from 'projects/avia/pages/AviaLanding/components/Breadcrumbs/BreadcrumbsDesktop/BreadcrumbsDesktop';
import AviaRouteBreadcrumbsMobile from 'projects/avia/pages/AviaLanding/components/Breadcrumbs/BreadcrumbsMobile/BreadcrumbsMobile';

const AviaRouteBreadcrumbs: React.FC<IAviaRouteBreadcrumbs> = ({
    className,
    block,
    ...props
}) => {
    const {data} = block;
    const nonce = useSelector(nonceSelector);
    const isMobile = useMobile();

    return (
        <div className={className}>
            {nonce && (
                <SchemaMarkup
                    data={getMetaBreadcrumbList(
                        data.items.map(({title, link}) => ({
                            url: link,
                            name: title,
                        })),
                    )}
                    nonce={nonce}
                />
            )}

            {isMobile ? (
                <AviaRouteBreadcrumbsMobile
                    block={block}
                    {...prepareQaAttributes(props)}
                />
            ) : (
                <AviaRouteBreadcrumbsDesktop
                    block={block}
                    {...prepareQaAttributes(props)}
                />
            )}
        </div>
    );
};

export default AviaRouteBreadcrumbs;
